# 存取本地数据
本节要实现一个功能：打开 APP 的时候是上次选择的城市。

所以需要把选择的城市的数据保存起来，这个时候需要用到第三方库：`shared_preferences`。

## 添加第三方库
在 `pubspec.yaml` 里添加：
```
dependencies:
  shared_preferences: ^0.5.2
```

然后运行：
```
flutter packages get
```

## 读取数据
在 HotWidgetState 的 initState() 里增加一个读取数据的方法 initData(),注意这里读取数据是异步的，所以 initData() 方法要加 async：
```
class HotWidgetState extends State<HotWidget> {
  String curCity;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    print('HotWidgetState initState');
    initData();
  }

  void initData() async {
    final prefs = await SharedPreferences.getInstance();//获取 prefs

    String city = prefs.getString('curCity');//获取 key 为 curCity 的值

    if (city != null && city.isNotEmpty) { //如果有值
      setState((){
        curCity = city;
      });
    } else {//如果没有值，则使用默认值
      setState((){
        curCity = '深圳';
      });
    }
  }
  ...
}
```

## UI 改造
因为读取数据是异步的，在 build Widget 的时候  curCity 可能就是空的，这样会导致拉取不到数据，所以 UI 这里要加一个逻辑，如果 curCity 不为空，就返回电影的UI,否则返回刷新界面：
```
Widget build(BuildContext context) {
    // TODO: implement build
    if (curCity != null && curCity.isNotEmpty) {//如果 curCity 不为空
      return Column(
        ...
      );
    } else {//如果 curCity 为空
      return Center(
        child: CircularProgressIndicator(),
      );
    }
  }
```
效果为：
![](https://user-gold-cdn.xitu.io/2019/4/29/16a68264bd5fd0b2?w=480&h=960&f=gif&s=201709)

## 存取数据
在 _jumpToCitysWidget 里增加存取数据的代码:
```
  void _jumpToCitysWidget() async {
    var selectCity =
        await Navigator.pushNamed(context, '/Citys', arguments: curCity);
    if (selectCity == null) return;

    final prefs = await SharedPreferences.getInstance(); 
    prefs.setString('curCity', selectCity); //存取数据

    setState(() {
      curCity = selectCity;
    });
  }
```